<?php
class MikroTikAPI {

  private $socket;

  public function connect($host, $user, $pass, $timeout = 5) {

    // Support format host:port
    if (strpos($host, ':') !== false) {
      [$host, $port] = explode(':', $host, 2);
    } else {
      $port = 8728; // default fallback
    }

    $this->socket = @fsockopen($host, (int)$port, $errno, $errstr, $timeout);
    if (!$this->socket) {
      throw new Exception("API connect failed: $errstr ($errno)");
    }

    // Login
    $this->writeWord("/login");
    $this->writeWord("=name=$user");
    $this->writeWord("=password=$pass");
    $this->writeWord("");

    $this->read(); // clear response
    return true;
  }

  private function writeWord($word) {
    $len = strlen($word);
    if ($len < 0x80) {
      fwrite($this->socket, chr($len) . $word);
    } elseif ($len < 0x4000) {
      fwrite($this->socket, chr(($len >> 8) | 0x80) . chr($len & 0xFF) . $word);
    }
  }

  private function read() {
    $response = [];
    while (true) {
      $len = ord(fread($this->socket, 1));
      if ($len === 0) break;
      $response[] = fread($this->socket, $len);
    }
    return $response;
  }

  public function command($cmd) {
    $this->writeWord($cmd);
    $this->writeWord("");
    return $this->read();
  }

  public function disconnect() {
    if ($this->socket) fclose($this->socket);
  }
}