<?php
require_once 'config.php';
require_once 'mikrotik_api.php';

try {

  $api = new MikroTikAPI();
  $api->connect(
    $router['host'],
    $router['user'],
    $router['pass']
  );

  // Ambil resource router
  $data = $api->command("/system/resource/print");

  $cpu = 0;
  $freeMem = 0;
  $uptime = 0;

  foreach ($data as $row) {
    if (strpos($row, "cpu-load=") !== false) {
      $cpu = (int)str_replace("cpu-load=", "", $row);
    }
    if (strpos($row, "free-memory=") !== false) {
      $freeMem = (int)str_replace("free-memory=", "", $row);
    }
    if (strpos($row, "uptime=") !== false) {
      $uptime = time(); // sementara, nanti bisa parse asli
    }
  }

  // Simpan ke database
  $stmt = $db->prepare("
    INSERT INTO router_stats
    (router_id, cpu, ram, uptime, traffic_rx, traffic_tx)
    VALUES (?, ?, ?, ?, 0, 0)
  ");

  $router_id = 1; // sementara hardcode
  $stmt->bind_param("iiii", $router_id, $cpu, $freeMem, $uptime);
  $stmt->execute();

  $api->disconnect();

  echo "✅ Monitoring OK | CPU: {$cpu}% | Free RAM: {$freeMem}";

} catch (Exception $e) {
  echo "❌ ERROR: " . $e->getMessage();
}